import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { Job } from "../types/job.js";

const locationRestJobGet: RouteLocationInterface = {
    path: "/job/:id",
    method: RouteHttpVerb.GET,
};

interface RequestRouteJobGet extends RouteRequestInterface {}

interface ParamsRouteJobGet extends RouteParamsInterface {
    id: number;
    lock?: boolean;
}

interface ResponseRouteJobGet extends RouteResponseInterface, Job {}

export { locationRestJobGet, type RequestRouteJobGet, type ParamsRouteJobGet, type ResponseRouteJobGet };
