import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRouteStatusGet } from "./status.get.js";
import type { Job } from "../types/job.js";
import type { OptionsOthers } from "../utils/options.js";

const locationRestJobExecute: RouteLocationInterface = {
    path: "/job/:id",
    method: RouteHttpVerb.POST,
};

interface RequestRouteJobExecute extends RouteRequestInterface {
    try?: string;
    additionalData?: string;
}

interface ParamsRouteJobExecute extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteJobExecute extends RouteResponseInterface {
    done: Job[];
    failed: Job[];
    remaining: OptionsOthers["remaining"];
    pauseToAvoidRecurringException: boolean;
    status: ResponseRouteStatusGet;
}

export {
    locationRestJobExecute,
    type RequestRouteJobExecute,
    type ParamsRouteJobExecute,
    type ResponseRouteJobExecute,
};
