import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { Job } from "../types/job.js";

const locationRestJobResultPost: RouteLocationInterface = {
    path: "/job/:id/result",
    method: RouteHttpVerb.POST,
};

interface RequestRouteJobResultPost extends RouteRequestInterface {
    process: number;
    errorCode?: string;
    errorMessage?: string;
    errorData?: string;
}

interface ParamsRouteJobResultPost extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteJobResultPost extends RouteResponseInterface {
    job: Job;
    pauseToAvoidRecurringException: boolean;
}

export {
    locationRestJobResultPost,
    type RequestRouteJobResultPost,
    type ParamsRouteJobResultPost,
    type ResponseRouteJobResultPost,
};
