import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestJobsDelete: RouteLocationInterface = {
    path: "/jobs",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteJobsDelete extends RouteRequestInterface {}

interface ParamsRouteJobsDelete extends RouteParamsInterface {
    type?: string;
}

interface ResponseRouteJobsDelete extends RouteResponseInterface {
    deleted: false | number;
}

export {
    locationRestJobsDelete,
    type RequestRouteJobsDelete,
    type ParamsRouteJobsDelete,
    type ResponseRouteJobsDelete,
};
