import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRouteStatusGet } from "./status.get.js";
import type { Job } from "../types/job.js";
import type { OptionsOthers } from "../utils/options.js";

const locationRestJobsGet: RouteLocationInterface = {
    path: "/jobs",
    method: RouteHttpVerb.GET,
};

interface RequestRouteJobsGet extends RouteRequestInterface {}

interface ParamsRouteJobsGet extends RouteParamsInterface {
    ids?: string;
    after?: number;
    additionalData?: string;
}

interface ResponseRouteJobsGet extends RouteResponseInterface {
    jobs: Array<Job>;
    remaining: OptionsOthers["remaining"];
    status: ResponseRouteStatusGet;
}

export { locationRestJobsGet, type RequestRouteJobsGet, type ParamsRouteJobsGet, type ResponseRouteJobsGet };
