import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestJobsSkipPost: RouteLocationInterface = {
    path: "/jobs/skip",
    method: RouteHttpVerb.POST,
};

interface RequestRouteJobsSkipPost extends RouteRequestInterface {
    type: string;
}

interface ParamsRouteJobsSkipPost extends RouteParamsInterface {}

interface ResponseRouteJobsSkipPost extends RouteResponseInterface {
    updated: false | number;
}

export {
    locationRestJobsSkipPost,
    type RequestRouteJobsSkipPost,
    type ParamsRouteJobsSkipPost,
    type ResponseRouteJobsSkipPost,
};
