import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { Job } from "../types/job.js";

const locationRestStatusGet: RouteLocationInterface = {
    path: "/status",
    method: RouteHttpVerb.GET,
};

interface RequestRouteStatusGet extends RouteRequestInterface {}

interface ParamsRouteStatusGet extends RouteParamsInterface {
    additionalData: string;
}

interface ResponseRouteStatusGet<AdditionalData extends Record<string, any> = object> extends RouteResponseInterface {
    currentJobs: Record<string, Job>;
    remaining: Record<
        string,
        {
            remaining: number;
            total: number;
            failure: number;
            paused: number;
        }
    >;
    additionalData: AdditionalData;
    errors: {
        hash: string;
        list: Record<
            string,
            {
                actions: Array<{
                    action?: "delete" | "retry" | "skip";
                    url: string;
                    linkText: string;
                    target?: string;
                }>;
                type: string;
                label: string;
                description: string;
                failedJobs: Job[];
            }
        >;
    };
}

export { locationRestStatusGet, type RequestRouteStatusGet, type ParamsRouteStatusGet, type ResponseRouteStatusGet };
