import "./style/cross.scss";
import $ from "jquery";

import { crossRcbGdprCompliant } from "./cross/rcb/gdprCompliant.js";
import { crossRclAddCategory } from "./cross/rcl/addCategory.js";
import { crossRclAddWcCategory } from "./cross/rcl/addWcCategory.js";
import { crossRclAssignGutenberg } from "./cross/rcl/assignGutenberg.js";
import { CrossRclClassicEditorAssign } from "./cross/rcl/classicEditorAssign.js";
import { CrossRclPagination } from "./cross/rcl/pagination.js";
import { crossRmlAttachmentDetails } from "./cross/rml/attachmentDetails.js";
import { crossRmlInsertDialog } from "./cross/rml/insertDialog.js";
import { crossRpmMove } from "./cross/rpm/move.js";
import { crossRpmUpload } from "./cross/rpm/upload.js";

$(document).ready(() => {
    const CHECK_INTERVAL_MS = 1000;

    /**
     * Visible-driven
     * Check by an given ms-interval for given elements and
     */
    function checkByInterval() {
        let found = false;
        !found && (found = crossRmlAttachmentDetails());
        !found && (found = crossRcbGdprCompliant());
        !found && (found = crossRmlInsertDialog());
        !found && (found = crossRclAssignGutenberg());
        !found && (found = crossRpmUpload());

        // Again, if nothing found
        !found && setTimeout(checkByInterval, CHECK_INTERVAL_MS);
    }
    setTimeout(checkByInterval, CHECK_INTERVAL_MS);

    // Event-driven
    crossRclAddCategory();
    crossRclAddWcCategory();
    crossRpmMove();
    CrossRclClassicEditorAssign.bind();
    CrossRclPagination.bind();
});
