import $ from "jquery";

import { CrossSellingPointer } from "../../others/crossSellingPointer.js";
import { RCL } from "../names.js";

/**
 * Add new category in Posts / Pages > Categories
 */
const crossRclAddCategory = () =>
    $("select#parent").length && // only for hierarchical taxonomies
    CrossSellingPointer.isActionAvailable(RCL, "add-category") &&
    $("body.wp-admin.edit-tags-php:not(.woocommerce-page,.post-type-attachment) form#addtag #submit").one(
        "click",
        function () {
            new CrossSellingPointer($(this), RCL, "add-category", "bottom");
        },
    );

export { crossRclAddCategory };
