import $ from "jquery";

import { CrossSellingPointer } from "../../others/crossSellingPointer.js";
import { RCL } from "../names.js";

/**
 * Assign in Classic Editor (needs to be extract as class to avoid multiple event triggers).
 */
class CrossRclClassicEditorAssign {
    public static readonly SELECTOR =
        'body.wp-admin.post-php:not(.post-type-attachment) #categorychecklist input[type="checkbox"]';

    public static onChange(this: HTMLElement) {
        new CrossSellingPointer($(this), RCL, "assign");
        $(CrossRclClassicEditorAssign.SELECTOR).off("change", CrossRclClassicEditorAssign.onChange);
    }

    public static bind() {
        CrossSellingPointer.isActionAvailable(RCL, "assign") && $(this.SELECTOR).one("change", this.onChange);
    }
}

export { CrossRclClassicEditorAssign };
