import { getStaticOptions } from "../utils/options.js";

/**
 * Check if current plugin can be rated.
 *
 * @param slug Do not use process.env.slug because it can be wrong when using lite version!
 */
function isRatable(slug: string) {
    return getStaticOptions().canBeRated.indexOf(slug) > -1;
}

export { isRatable };
