import { BaseOptions } from "@devowl-wp/utils";

/**
 * As we do not rely on a real store in our package (should be lightweight)
 * we can use the window object as variable.
 */
interface OptionsOthers {
    canBeRated: string[];
    rateLinks: {
        [key: string]: string;
    };
    names: {
        [key: string]: string;
    };
    cross: {
        [key: string]: {
            [key: string]: {
                title: string;
                image: string;
                description: string;
                link: string;
                dismissed: number;
            };
        };
    };
}

const getStaticOptions = () => (window as any)[BaseOptions.getPureSlug(process.env.slug, true)].others as OptionsOthers;

export { type OptionsOthers, getStaticOptions };
