import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCrossDismissDelete: RouteLocationInterface = {
    path: "/cross/:slug/:action/dismiss",
    method: RouteHttpVerb.DELETE,
};

interface RequestRestCrossDismissDelete extends RouteRequestInterface {}

interface ParamsRestCrossDismissDelete extends RouteParamsInterface {
    slug: string;
    action: string;
    force?: boolean;
}

interface ResponseRestCrossDismissDelete extends RouteResponseInterface {}

export {
    locationRestCrossDismissDelete,
    type RequestRestCrossDismissDelete,
    type ParamsRestCrossDismissDelete,
    type ResponseRestCrossDismissDelete,
};
