import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestFeedbackPost: RouteLocationInterface = {
    path: "/feedback/:slug",
    method: RouteHttpVerb.POST,
};

interface RequestRestFeedbackPost extends RouteRequestInterface {
    reason: string;
    note: string;
    email?: string;
}

interface ParamsRestFeedbackPost extends RouteParamsInterface {
    slug: string;
}

interface ResponseRestFeedbackPost extends RouteResponseInterface {}

export {
    locationRestFeedbackPost,
    type RequestRestFeedbackPost,
    type ParamsRestFeedbackPost,
    type ResponseRestFeedbackPost,
};
