import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestRatingDismissDelete: RouteLocationInterface = {
    path: "/rating/:slug/dismiss",
    method: RouteHttpVerb.DELETE,
};

interface RequestRestRatingDismissDelete extends RouteRequestInterface {}

interface ParamsRestRatingDismissDelete extends RouteParamsInterface {
    slug: string;
    force?: boolean;
}

interface ResponseRestRatingDismissDelete extends RouteResponseInterface {}

export {
    locationRestRatingDismissDelete,
    type RequestRestRatingDismissDelete,
    type ParamsRestRatingDismissDelete,
    type ResponseRestRatingDismissDelete,
};
