import { resolve } from "node:path";

import { createDefaultSettings } from "@devowl-wp/webpack-config";

export default [
    // This is our exposed library
    createDefaultSettings(import.meta.filename, "package", {
        override: ([config], factoryValues) => {
            // Disable vendor chunks
            config.optimization.splitChunks = undefined;

            // Manually create entries
            config.entry = {
                helper: resolve(factoryValues.pwd, "lib/helper.tsx"),
            };
        },
    }),
    // This are entrypoints which simply needs to get enqueued and they do something standalone
    createDefaultSettings(import.meta.filename, "package", {
        override: ([config], factoryValues) => {
            config.name = "others";

            // Disable vendor chunks
            config.optimization.splitChunks = undefined;
            delete config.output.library;

            // Manually create entries
            config.entry = {
                cross: resolve(factoryValues.pwd, "lib/cross.tsx"),
                // @deprecated Use package `real-product-manager-wp-client` instead
                feedback: resolve(factoryValues.pwd, "lib/feedback.tsx"),
                welcome: resolve(factoryValues.pwd, "lib/welcome.tsx"),
            };
        },
        webpackBarOptions: (options) => {
            options.name = `${options.name}-others`;
            return options;
        },
    }),
].flat();
