import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestQueryGet: RouteLocationInterface = {
    path: "/:name/query",
    method: RouteHttpVerb.GET,
    namespace: "search-engine-post-type/v1",
};

interface RequestRouteQueryGet extends RouteRequestInterface {}

interface ParamsRouteQueryGet extends RouteParamsInterface {
    name: string;
    term: string;
    hitsPerPage?: number;
    taxonomy?: string;
    slugs?: string;
    _dataLocale?: string;
}

interface ResponseRouteQueryGet extends RouteResponseInterface {
    hits: {
        id: number;
        title: string;
        subtitle: string;
        content: string;
        introduction: string;
        toc: string[];
        permalink: string;
        taxonomies_first: Record<string, string[]>;
    }[];
    allHits: number;
    page: number;
    allPages: number;
    hitsPerPage: number;
}

export { locationRestQueryGet, type RequestRouteQueryGet, type ParamsRouteQueryGet, type ResponseRouteQueryGet };
