<?php
namespace DevOwl\SearchEnginePostType;

/**
 * A hit in simple term: A single search result.
 */
class Hit {
    use UtilsProvider;

    /**
     * Post ID.
     *
     * @var int
     */
    public $id;

    /**
     * The title (`post_title`). Can have HTML markup to highlight query term.
     *
     * @var string
     */
    public $title;

    /**
     * The subtitle of a found post content. This is only filled if found and `HtmlSplitter` is used.
     *
     * @var string
     */
    public $subtitle;

    /**
     * Truncated content (`post_content`). Can have HTML markup to highlight query term.
     *
     * @var string
     */
    public $content;

    /**
     * Full introduction text for this post.
     *
     * @var string
     */
    public $introduction;

    /**
     * Table of contents for this post.
     *
     * @var string[]
     */
    public $toc = [];

    /**
     * Referenced taxonomies but only first level.
     *
     * @var array[]
     */
    public $taxonomies_first = [];

    /**
     * The permalink to the post.
     *
     * @var string
     */
    public $permalink;

    /**
     * The original response received from the provider for this hit.
     *
     * @var array
     */
    private $originalResponse;

    /**
     * C'tor.
     *
     * @param array $originalResponse
     * @codeCoverageIgnore
     */
    public function __construct($originalResponse) {
        $this->originalResponse = $originalResponse;
    }

    // Self-explanatory
    public function getOriginalResponse() {
        return $this->originalResponse;
    }
}
