<?php
namespace DevOwl\SearchEnginePostType;

/**
 * A result is a set of hits and additional properties like current page.
 */
class Result {
    use UtilsProvider;

    /**
     * A list of found hits (limited to requested page).
     *
     * @var Hit[]
     */
    public $hits = [];

    /**
     * Count of all found hits for this query.
     *
     * @var int
     */
    public $allHits;

    /**
     * Current page for this query
     *
     * @var int
     */
    public $page;

    /**
     * Count of all available pages for this query.
     *
     * @var int
     */
    public $allPages;

    /**
     * Count of hits returned per page.
     *
     * @var int
     */
    public $hitsPerPage;

    /**
     * The original response received from the provider.
     *
     * @var array
     */
    private $originalResponse;

    /**
     * C'tor.
     *
     * @param array $originalResponse
     * @codeCoverageIgnore
     */
    public function __construct($originalResponse) {
        $this->originalResponse = $originalResponse;
    }

    /**
     * Add a new hit to this result.
     *
     * @param Hit $hit
     */
    public function addHit($hit) {
        return $this->hits[] = $hit;
    }

    // Self-explanatory
    public function getOriginalResponse() {
        return $this->originalResponse;
    }
}
