<?php
namespace DevOwl\SearchEnginePostType;

use MatthiasWeb\Utils\Base;

// @codeCoverageIgnoreStart
defined('ABSPATH') or die('No script kiddies please!'); // Avoid direct file request
// @codeCoverageIgnoreEnd

/**
 * Let our package act as own "plugin".
 */
trait UtilsProvider {
    use Base;

    /**
     * Get the prefix of this package so we can utils package natively.
     *
     * @return string
     */
    public function getPluginConstantPrefix() {
        self::setupConstants();
        return 'SEARCH_ENGINE_PT';
    }

    /**
     * Make sure the SEARCH_ENGINE_PT constants are available.
     */
    public static function setupConstants() {
        if (defined('SEARCH_ENGINE_PT_SLUG')) {
            return;
        }

        define('SEARCH_ENGINE_PT_SLUG', 'search-engine-post-type');
        define('SEARCH_ENGINE_PT_ROOT_SLUG', 'devowl-wp');
        define('SEARCH_ENGINE_PT_TD', SEARCH_ENGINE_PT_ROOT_SLUG . '-' . SEARCH_ENGINE_PT_SLUG);
        define('SEARCH_ENGINE_PT_SLUG_CAMELCASE', lcfirst(str_replace('-', '', ucwords(SEARCH_ENGINE_PT_SLUG, '-'))));
        define('SEARCH_ENGINE_PT_VERSION', filemtime(__FILE__)); // as we do serve assets through the consumer plugin we can safely use file modified time
        define('SEARCH_ENGINE_PT_OPT_PREFIX', 'search-engine-pt');
    }
}
