import { useChunkTranslation } from "../hooks/useChunkTranslation.js";

import type { FC, PropsWithChildren, ReactNode } from "react";

const SuspenseChunkTranslation: FC<
    PropsWithChildren<{
        chunkFile: Parameters<typeof useChunkTranslation>[0];
        options: () => Parameters<typeof useChunkTranslation>[1];
        fallback: ReactNode;
    }>
> = ({ children, chunkFile, fallback, options }) => {
    const done = useChunkTranslation(chunkFile, options());
    return <>{done ? children : fallback}</>;
};

export { SuspenseChunkTranslation };
