/**
 * See PHP file inc/Assets.php.
 */
abstract class BaseOptions {
    public slug: string;
    public textDomain: string;
    public version: string;
    public restUrl?: string;
    public restNamespace?: string;
    public restRoot?: string;
    public restQuery?: object;
    public restNonce?: string;
    public restRecreateNonceEndpoint?: string;
    public restPathObfuscateOffset?: string;
    public publicUrl?: string;
    public chunkFolder?: string;
    public chunksLanguageFolder?: string;
    public chunks?: Record<string, string[]>;

    /**
     * Convert a slug like "my-plugin" to "myPlugin". This can
     * be useful for library naming (window[""] is bad because the hyphens).
     */
    public static slugCamelCase(slug: string) {
        return slug.replace(/-([a-z])/g, (g) => g[1].toUpperCase());
    }

    /**
     * Get the slug from the current process (webpack) instead of the PHP plugin output.
     * For some cases you need to use that.
     */
    public static getPureSlug(slug: string, camelCase = false) {
        return camelCase ? BaseOptions.slugCamelCase(slug) : slug;
    }
}

export { BaseOptions };
