import { ERouteHttpVerb } from "@devowl-wp/api";

import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "../factory/ajax/commonUrlBuilder.js";

const locationRestKeyValueMapPatch: RouteLocationInterface = {
    path: "/key-value-map/:name/:key",
    method: ERouteHttpVerb.PATCH,
};

interface RequestRouteKeyValueMapPatch<ValueType = any> extends RouteRequestInterface {
    value: ValueType;
}

interface ParamsRouteKeyValueMapPatch extends RouteParamsInterface {
    name: string;
    key: string;
}

interface ResponseRouteKeyValueMapPatch<ValueType = any> extends RouteResponseInterface {
    key: string;
    value: ValueType;
}

export {
    locationRestKeyValueMapPatch,
    type RequestRouteKeyValueMapPatch,
    type ParamsRouteKeyValueMapPatch,
    type ResponseRouteKeyValueMapPatch,
};
