import { ClientModel } from "../clientModel.js";

interface CategoryProperties {
    count: number;
    description: string;
    id: number;
    link: string;
    name: string;
    slug: string;
    taxonomy: string;
}

abstract class AbstractCategory<
    Collection = object,
    Meta = object,
    Data = object,
    UnionProperties = CategoryProperties & Data & { meta: Meta },
> extends ClientModel<{
    key: number;
    collection: Collection;
    delete: {
        parameters: {
            id?: number;
            force: true;
        };
        response: UnionProperties | { deleted: true; previous: UnionProperties };
    };
    patch: {
        parameters: { id?: number };
    };
    properties: UnionProperties;
}> {
    public transformDataForPersist(): any {
        const data = { ...super.transformDataForPersist() };
        delete data._links;
        delete data.link;
        return data;
    }

    public transformDataForPatch(): any {
        return this.transformDataForPersist();
    }
}

export { AbstractCategory };
