import { ClientCollection } from "../clientCollection.js";

import type { AbstractCategory } from "./abstractCategory.js";

abstract class AbstractCategoryCollection<
    T extends AbstractCategory,
    AdditionalParameters = object,
    AdditionalSingleParameters = object,
> extends ClientCollection<{
    model: T;
    getParameters: {
        context?: "view" | "embed" | "edit";
        page?: number;
        per_page?: number;
        search?: string;
        exclude?: number[];
        include?: number[];
        order?: "asc" | "desc";
        orderby?:
            | "id"
            | "include"
            | "name"
            | "slug"
            | "include_slugs"
            | "term_group"
            | "description"
            | "count"
            | string;
        hide_empty?: boolean;
        parent?: number;
        post?: number;
        slug?: string | string[];
    } & AdditionalParameters;
    getSingleParameters: {
        id: number;
        context?: "view" | "embed" | "edit";
    } & AdditionalSingleParameters;
}> {}

export { AbstractCategoryCollection };
