import { ClientModel } from "../clientModel.js";

type PostStatus = "publish" | "draft" | "pending" | "future" | "trash" | "private";

interface PostProperties {
    content: {
        block_version?: number;
        protected: boolean;
        raw?: string;
        rendered?: string;
    };
    date: string;
    date_gmt: string;
    guid: {
        rendered: string;
        raw?: string;
    };
    id: number;
    link: string;
    menu_order: number;
    modified: string;
    modified_gmt: string;
    slug: string;
    status: PostStatus;
    template: string;
    title: {
        rendered?: string;
        raw?: string;
    };
    type: string;
}

abstract class AbstractPost<
    Collection = object,
    Meta = object,
    Data = object,
    UnionProperties = PostProperties & Data & { meta: Meta },
> extends ClientModel<{
    key: number;
    collection: Collection;
    delete: {
        parameters: {
            id?: number;
            force?: boolean;
        };
        response: UnionProperties | { deleted: true; previous: UnionProperties };
    };
    patch: {
        parameters: { id?: number };
    };
    properties: UnionProperties;
}> {
    public transformDataForPersist(): any {
        const data = { ...super.transformDataForPersist() };
        data.title = typeof data.title?.raw === "string" ? data.title.raw : data.title?.rendered;
        data.content = typeof data.content?.raw === "string" ? data.content.raw : data.content?.rendered;
        delete data._links;
        delete data.link;
        return data;
    }

    public transformDataForPatch(): any {
        return this.transformDataForPersist();
    }
}

export { AbstractPost, type PostStatus };
