import { ClientCollection } from "../clientCollection.js";

import type { AbstractPost, PostStatus } from "./abstractPost.js";

abstract class AbstractPostCollection<
    T extends AbstractPost,
    AdditionalParameters = object,
    AdditionalSingleParameters = object,
> extends ClientCollection<{
    model: T;
    getParameters: {
        context?: "view" | "embed" | "edit";
        page?: number;
        per_page?: number;
        search?: string;
        after?: string;
        author?: string | number | string[] | number[];
        author_exclude?: string | number | string[] | number[];
        before?: string;
        exclude?: number[];
        include?: number[];
        offset?: number;
        order?: "asc" | "desc";
        orderby?:
            | "author"
            | "date"
            | "id"
            | "include"
            | "modified"
            | "parent"
            | "relevance"
            | "slug"
            | "include_slugs"
            | "title"
            | string;
        slug?: string | string[];
        status?: PostStatus | PostStatus[];
        tax_relation?: "AND" | "OR";
        categories?: number[];
        categories_exclude?: number[];
        tags?: number[];
        tags_exclude?: number[];
        sticky?: boolean;
    } & AdditionalParameters;
    getSingleParameters: {
        id: number;
        context?: "view" | "embed" | "edit";
    } & AdditionalSingleParameters;
}> {}

export { AbstractPostCollection };
