import { ERouteHttpVerb } from "@devowl-wp/api";

import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "../factory/ajax/commonUrlBuilder.js";

const locationRestPluginGet: RouteLocationInterface = {
    path: "/plugin",
    method: ERouteHttpVerb.GET,
};

interface RequestRoutePluginGet extends RouteRequestInterface {}

interface ParamsRoutePluginGet extends RouteParamsInterface {}

interface ResponseRoutePluginGet extends RouteResponseInterface {
    Name: string;
    PluginURI: string;
    Version: string;
    Description: string;
    Author: string;
    AuthorURI: string;
    TextDomain: string;
    DomainPath: string;
    Network: boolean;
    Title: string;
    AuthorName: string;
}

export { locationRestPluginGet, type RequestRoutePluginGet, type ParamsRoutePluginGet, type ResponseRoutePluginGet };
