<?php
/**
 * This file uses the official WordPress README parser to parse the README.txt file in
 * wordpress.org/README.wporg.txt and generates a JSON file. This is useful to upload the
 * POT file to a Continuous Localization platform like Weblate.
 *
 * Usage:
 *
 * README_FILE=<absolute path to README.txt> php scripts/readme-to-json/index.php
 */

use WordPressdotorg\Plugin_Directory\Readme\Parser;

include_once __DIR__ . '/../../vendor/autoload.php';
include_once __DIR__ . '/download-class-markdown.php';
include_once __DIR__ . '/download-class-parser.php';
include_once __DIR__ . '/download-kses.php';
include_once __DIR__ . '/download-formatting.php';
include_once __DIR__ . '/wp-functions.php';

$readme_file = getenv('README_FILE');

// Create Parser instance
// https://github.com/WordPress/wordpress.org/blob/34e0102bb1e28a20a1f4f98a380122b82dacecc2/wordpress.org/public_html/wp-content/plugins/plugin-directory/cli/i18n/class-readme-import.php#L47
$readme = new Parser($readme_file);

$result = [];

$addMsgId = function ($id) use (&$result) {
    $result[$id] = $id;
};

if ($readme->name) {
    $addMsgId($readme->name);
}

if ($readme->short_description) {
    $addMsgId($readme->short_description);
}

if ($readme->screenshots) {
    foreach ($readme->screenshots as $screenshot) {
        $addMsgId($screenshot);
    }
}

// https://github.com/WordPress/wordpress.org/blob/34e0102bb1e28a20a1f4f98a380122b82dacecc2/wordpress.org/public_html/wp-content/plugins/plugin-directory/cli/i18n/class-readme-import.php#L156
function handle_translator_comment($array, $key, $val) {
    $val = trim(preg_replace('/[^a-z0-9]/i', ' ', $val)); // cleanup key names for display.

    if (empty($array[$key])) {
        $array[$key] = [$val];
    } elseif (!in_array($val, $array[$key], true)) {
        $array[$key][] = $val;
    }

    return $array;
}

$section_strings = [];
foreach ($readme->sections as $section_key => $section_text) {
    if ('changelog' !== $section_key) {
        // No need to scan non-translatable version headers in changelog.
        if (preg_match_all('~<(h[3-4]|dt)[^>]*>([^<].+)</\1>~', $section_text, $matches)) {
            if (!empty($matches[2])) {
                foreach ($matches[2] as $text) {
                    $section_strings = handle_translator_comment($section_strings, $text, "{$section_key} header");
                }
            }
        }
    }

    if (preg_match_all('|<li>(?!<p>)([\s\S]*?)</li>|', $section_text, $matches)) {
        if (!empty($matches[1])) {
            foreach ($matches[1] as $text) {
                $section_strings = handle_translator_comment($section_strings, $text, "{$section_key} list item");
            }
        }
    }

    if (preg_match_all('|<p>([\s\S]*?)</p>|', $section_text, $matches)) {
        if (!empty($matches[1])) {
            foreach ($matches[1] as $text) {
                $section_strings = handle_translator_comment($section_strings, trim($text), "{$section_key} paragraph");
            }
        }
    }
}

foreach ($section_strings as $text => $comments) {
    $addMsgId($text);
}

echo json_encode($result);
