<?php
// Override
function apply_filters($hook_name, $value, ...$args) {
    return $value;
}

// Override
function wp_load_alloptions() {
    return [
        'blog_charset' => 'utf-8',
    ];
}

// Override
function get_option($option, $default_value = false) {
    switch ($option) {
        case 'charset':
        case 'blog_charset':
            return 'utf-8';
        default:
            throw new Exception($option . ' option not defined.');
    }
}

// Override
function get_user_by($field, $value) {
    return false;
}

// Override
function wp_allowed_protocols() {
    static $protocols = [];

    if (empty($protocols)) {
        $protocols = [
            'http',
            'https',
            'ftp',
            'ftps',
            'mailto',
            'news',
            'irc',
            'irc6',
            'ircs',
            'gopher',
            'nntp',
            'feed',
            'telnet',
            'mms',
            'rtsp',
            'sms',
            'svn',
            'tel',
            'fax',
            'xmpp',
            'webcal',
            'urn',
        ];
    }

    return $protocols;
}

// Override
function taxonomy_exists($taxonomy) {
    return false;
}
