<?php
// phpcs:disable

/**
 * The newest version of `wordpress-stubs` does no longer expose this classes, so we need to maintain
 * them manually. We can safely remove them when we drop support for WordPress 6.1 and support only WordPress >= 6.2.
 *
 * @see https://raw.githubusercontent.com/php-stubs/wordpress-stubs/v5.9.0/wordpress-stubs.php
 */
namespace {
    /**
     * Cookie storage object
     *
     * @package Requests
     * @subpackage Cookies
     */
    class Requests_Cookie {
        /**
         * Cookie name.
         *
         * @var string
         */
        public $name;
        /**
         * Cookie value.
         *
         * @var string
         */
        public $value;
        /**
         * Cookie attributes
         *
         * Valid keys are (currently) path, domain, expires, max-age, secure and
         * httponly.
         *
         * @var Requests_Utility_CaseInsensitiveDictionary|array Array-like object
         */
        public $attributes = [];
        /**
         * Cookie flags
         *
         * Valid keys are (currently) creation, last-access, persistent and
         * host-only.
         *
         * @var array
         */
        public $flags = [];
        /**
         * Reference time for relative calculations
         *
         * This is used in place of `time()` when calculating Max-Age expiration and
         * checking time validity.
         *
         * @var int
         */
        public $reference_time = 0;
        /**
         * Create a new cookie object
         *
         * @param string $name
         * @param string $value
         * @param array|Requests_Utility_CaseInsensitiveDictionary $attributes Associative array of attribute data
         */
        public function __construct($name, $value, $attributes = [], $flags = [], $reference_time = \null) {
        }
        /**
         * Check if a cookie is expired.
         *
         * Checks the age against $this->reference_time to determine if the cookie
         * is expired.
         *
         * @return boolean True if expired, false if time is valid.
         */
        public function is_expired() {
        }
        /**
         * Check if a cookie is valid for a given URI
         *
         * @param Requests_IRI $uri URI to check
         * @return boolean Whether the cookie is valid for the given URI
         */
        public function uri_matches(\Requests_IRI $uri) {
        }
        /**
         * Check if a cookie is valid for a given domain
         *
         * @param string $string Domain to check
         * @return boolean Whether the cookie is valid for the given domain
         */
        public function domain_matches($string) {
        }
        /**
         * Check if a cookie is valid for a given path
         *
         * From the path-match check in RFC 6265 section 5.1.4
         *
         * @param string $request_path Path to check
         * @return boolean Whether the cookie is valid for the given path
         */
        public function path_matches($request_path) {
        }
        /**
         * Normalize cookie and attributes
         *
         * @return boolean Whether the cookie was successfully normalized
         */
        public function normalize() {
        }
        /**
         * Parse an individual cookie attribute
         *
         * Handles parsing individual attributes from the cookie values.
         *
         * @param string $name Attribute name
         * @param string|boolean $value Attribute value (string value, or true if empty/flag)
         * @return mixed Value if available, or null if the attribute value is invalid (and should be skipped)
         */
        protected function normalize_attribute($name, $value) {
        }
        /**
         * Format a cookie for a Cookie header
         *
         * This is used when sending cookies to a server.
         *
         * @return string Cookie formatted for Cookie header
         */
        public function format_for_header() {
        }
        /**
         * Format a cookie for a Cookie header
         *
         * @codeCoverageIgnore
         * @deprecated Use {@see Requests_Cookie::format_for_header}
         * @return string
         */
        public function formatForHeader() {
        }
        /**
         * Format a cookie for a Set-Cookie header
         *
         * This is used when sending cookies to clients. This isn't really
         * applicable to client-side usage, but might be handy for debugging.
         *
         * @return string Cookie formatted for Set-Cookie header
         */
        public function format_for_set_cookie() {
        }
        /**
         * Format a cookie for a Set-Cookie header
         *
         * @codeCoverageIgnore
         * @deprecated Use {@see Requests_Cookie::format_for_set_cookie}
         * @return string
         */
        public function formatForSetCookie() {
        }
        /**
         * Get the cookie value
         *
         * Attributes and other data can be accessed via methods.
         */
        public function __toString() {
        }
        /**
         * Parse a cookie string into a cookie object
         *
         * Based on Mozilla's parsing code in Firefox and related projects, which
         * is an intentional deviation from RFC 2109 and RFC 2616. RFC 6265
         * specifies some of this handling, but not in a thorough manner.
         *
         * @param string Cookie header value (from a Set-Cookie header)
         * @return Requests_Cookie Parsed cookie object
         */
        public static function parse($string, $name = '', $reference_time = \null) {
        }
        /**
         * Parse all Set-Cookie headers from request headers
         *
         * @param Requests_Response_Headers $headers Headers to parse from
         * @param Requests_IRI|null $origin URI for comparing cookie origins
         * @param int|null $time Reference time for expiration calculation
         * @return array
         */
        public static function parse_from_headers(
            \Requests_Response_Headers $headers,
            \Requests_IRI $origin = \null,
            $time = \null
        ) {
        }
        /**
         * Parse all Set-Cookie headers from request headers
         *
         * @codeCoverageIgnore
         * @deprecated Use {@see Requests_Cookie::parse_from_headers}
         * @return array
         */
        public static function parseFromHeaders(\Requests_Response_Headers $headers) {
        }
    }
    /**
     * Case-insensitive dictionary, suitable for HTTP headers
     *
     * @package Requests
     * @subpackage Utilities
     */
    class Requests_Utility_CaseInsensitiveDictionary implements \ArrayAccess, \IteratorAggregate {
        /**
         * Actual item data
         *
         * @var array
         */
        protected $data = [];
        /**
         * Creates a case insensitive dictionary.
         *
         * @param array $data Dictionary/map to convert to case-insensitive
         */
        public function __construct(array $data = []) {
        }
        /**
         * Check if the given item exists
         *
         * @param string $key Item key
         * @return boolean Does the item exist?
         */
        public function offsetExists($key) {
        }
        /**
         * Get the value for the item
         *
         * @param string $key Item key
         * @return string|null Item value (null if offsetExists is false)
         */
        public function offsetGet($key) {
        }
        /**
         * Set the given item
         *
         * @throws Requests_Exception On attempting to use dictionary as list (`invalidset`)
         *
         * @param string $key Item name
         * @param string $value Item value
         */
        public function offsetSet($key, $value) {
        }
        /**
         * Unset the given header
         *
         * @param string $key
         */
        public function offsetUnset($key) {
        }
        /**
         * Get an iterator for the data
         *
         * @return ArrayIterator
         */
        public function getIterator() {
        }
        /**
         * Get the headers as an array
         *
         * @return array Header data
         */
        public function getAll() {
        }
    }

    /**
     * Case-insensitive dictionary, suitable for HTTP headers
     *
     * @package Requests
     */
    class Requests_Response_Headers extends Requests_Utility_CaseInsensitiveDictionary {
        /**
         * Get the given header
         *
         * Unlike {@see self::getValues()}, this returns a string. If there are
         * multiple values, it concatenates them with a comma as per RFC2616.
         *
         * Avoid using this where commas may be used unquoted in values, such as
         * Set-Cookie headers.
         *
         * @param string $key
         * @return string|null Header value
         */
        public function offsetGet($key) {
        }
        /**
         * Set the given item
         *
         * @throws Requests_Exception On attempting to use dictionary as list (`invalidset`)
         *
         * @param string $key Item name
         * @param string $value Item value
         */
        public function offsetSet($key, $value) {
        }
        /**
         * Get all values for a given header
         *
         * @param string $key
         * @return array|null Header values
         */
        public function getValues($key) {
        }
        /**
         * Flattens a value into a string
         *
         * Converts an array into a string by imploding values with a comma, as per
         * RFC2616's rules for folding headers.
         *
         * @param string|array $value Value to flatten
         * @return string Flattened value
         */
        public function flatten($value) {
        }
        /**
         * Get an iterator for the data
         *
         * Converts the internal
         * @return ArrayIterator
         */
        public function getIterator() {
        }
    }

    /**
     * IDNA URL encoder
     *
     * Note: Not fully compliant, as nameprep does nothing yet.
     *
     * @package Requests
     * @subpackage Utilities
     * @see https://tools.ietf.org/html/rfc3490 IDNA specification
     * @see https://tools.ietf.org/html/rfc3492 Punycode/Bootstrap specification
     */
    class Requests_IDNAEncoder {
        /**
         * ACE prefix used for IDNA
         *
         * @see https://tools.ietf.org/html/rfc3490#section-5
         * @var string
         */
        const ACE_PREFIX = 'xn--';
        /**#@+
         * Bootstrap constant for Punycode
         *
         * @see https://tools.ietf.org/html/rfc3492#section-5
         * @var int
         */
        const BOOTSTRAP_BASE = 36;
        const BOOTSTRAP_TMIN = 1;
        const BOOTSTRAP_TMAX = 26;
        const BOOTSTRAP_SKEW = 38;
        const BOOTSTRAP_DAMP = 700;
        const BOOTSTRAP_INITIAL_BIAS = 72;
        const BOOTSTRAP_INITIAL_N = 128;
        /**#@-*/
        /**
         * Encode a hostname using Punycode
         *
         * @param string $string Hostname
         * @return string Punycode-encoded hostname
         */
        public static function encode($string) {
        }
        /**
         * Convert a UTF-8 string to an ASCII string using Punycode
         *
         * @throws Requests_Exception Provided string longer than 64 ASCII characters (`idna.provided_too_long`)
         * @throws Requests_Exception Prepared string longer than 64 ASCII characters (`idna.prepared_too_long`)
         * @throws Requests_Exception Provided string already begins with xn-- (`idna.provided_is_prefixed`)
         * @throws Requests_Exception Encoded string longer than 64 ASCII characters (`idna.encoded_too_long`)
         *
         * @param string $string ASCII or UTF-8 string (max length 64 characters)
         * @return string ASCII string
         */
        public static function to_ascii($string) {
        }
        /**
         * Check whether a given string contains only ASCII characters
         *
         * @internal (Testing found regex was the fastest implementation)
         *
         * @param string $string
         * @return bool Is the string ASCII-only?
         */
        protected static function is_ascii($string) {
        }
        /**
         * Prepare a string for use as an IDNA name
         *
         * @todo Implement this based on RFC 3491 and the newer 5891
         * @param string $string
         * @return string Prepared string
         */
        protected static function nameprep($string) {
        }
        /**
         * Convert a UTF-8 string to a UCS-4 codepoint array
         *
         * Based on Requests_IRI::replace_invalid_with_pct_encoding()
         *
         * @throws Requests_Exception Invalid UTF-8 codepoint (`idna.invalidcodepoint`)
         * @param string $input
         * @return array Unicode code points
         */
        protected static function utf8_to_codepoints($input) {
        }
        /**
         * RFC3492-compliant encoder
         *
         * @internal Pseudo-code from Section 6.3 is commented with "#" next to relevant code
         * @throws Requests_Exception On character outside of the domain (never happens with Punycode) (`idna.character_outside_domain`)
         *
         * @param string $input UTF-8 encoded string to encode
         * @return string Punycode-encoded string
         */
        public static function punycode_encode($input) {
        }
        /**
         * Convert a digit to its respective character
         *
         * @see https://tools.ietf.org/html/rfc3492#section-5
         * @throws Requests_Exception On invalid digit (`idna.invalid_digit`)
         *
         * @param int $digit Digit in the range 0-35
         * @return string Single character corresponding to digit
         */
        protected static function digit_to_char($digit) {
        }
        /**
         * Adapt the bias
         *
         * @see https://tools.ietf.org/html/rfc3492#section-6.1
         * @param int $delta
         * @param int $numpoints
         * @param bool $firsttime
         * @return int New bias
         *
         * function adapt(delta,numpoints,firsttime):
         */
        protected static function adapt($delta, $numpoints, $firsttime) {
        }
    }

    /**
     * HTTP response class
     *
     * Contains a response from Requests::request()
     * @package Requests
     */
    /**
     * HTTP response class
     *
     * Contains a response from Requests::request()
     * @package Requests
     */
    class Requests_Response {
        /**
         * Constructor
         */
        public function __construct() {
        }
        /**
         * Response body
         *
         * @var string
         */
        public $body = '';
        /**
         * Raw HTTP data from the transport
         *
         * @var string
         */
        public $raw = '';
        /**
         * Headers, as an associative array
         *
         * @var Requests_Response_Headers Array-like object representing headers
         */
        public $headers = [];
        /**
         * Status code, false if non-blocking
         *
         * @var integer|boolean
         */
        public $status_code = \false;
        /**
         * Protocol version, false if non-blocking
         *
         * @var float|boolean
         */
        public $protocol_version = \false;
        /**
         * Whether the request succeeded or not
         *
         * @var boolean
         */
        public $success = \false;
        /**
         * Number of redirects the request used
         *
         * @var integer
         */
        public $redirects = 0;
        /**
         * URL requested
         *
         * @var string
         */
        public $url = '';
        /**
         * Previous requests (from redirects)
         *
         * @var array Array of Requests_Response objects
         */
        public $history = [];
        /**
         * Cookies from the request
         *
         * @var Requests_Cookie_Jar Array-like object representing a cookie jar
         */
        public $cookies = [];
        /**
         * Is the response a redirect?
         *
         * @return boolean True if redirect (3xx status), false if not.
         */
        public function is_redirect() {
        }
        /**
         * Throws an exception if the request was not successful
         *
         * @throws Requests_Exception If `$allow_redirects` is false, and code is 3xx (`response.no_redirects`)
         * @throws Requests_Exception_HTTP On non-successful status code. Exception class corresponds to code (e.g. {@see Requests_Exception_HTTP_404})
         * @param boolean $allow_redirects Set to false to throw on a 3xx as well
         */
        public function throw_for_status($allow_redirects = \true) {
        }
    }

    /**
     * IRI parser/serialiser/normaliser
     *
     * Copyright (c) 2007-2010, Geoffrey Sneddon and Steve Minutillo.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions are met:
     *
     *  * Redistributions of source code must retain the above copyright notice,
     *       this list of conditions and the following disclaimer.
     *
     *  * Redistributions in binary form must reproduce the above copyright notice,
     *       this list of conditions and the following disclaimer in the documentation
     *       and/or other materials provided with the distribution.
     *
     *  * Neither the name of the SimplePie Team nor the names of its contributors
     *       may be used to endorse or promote products derived from this software
     *       without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
     * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
     * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
     * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
     * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
     * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
     * POSSIBILITY OF SUCH DAMAGE.
     *
     * @package Requests
     * @subpackage Utilities
     * @author Geoffrey Sneddon
     * @author Steve Minutillo
     * @copyright 2007-2009 Geoffrey Sneddon and Steve Minutillo
     * @license http://www.opensource.org/licenses/bsd-license.php
     * @link http://hg.gsnedders.com/iri/
     *
     * @property string $iri IRI we're working with
     * @property-read string $uri IRI in URI form, {@see to_uri}
     * @property string $scheme Scheme part of the IRI
     * @property string $authority Authority part, formatted for a URI (userinfo + host + port)
     * @property string $iauthority Authority part of the IRI (userinfo + host + port)
     * @property string $userinfo Userinfo part, formatted for a URI (after '://' and before '@')
     * @property string $iuserinfo Userinfo part of the IRI (after '://' and before '@')
     * @property string $host Host part, formatted for a URI
     * @property string $ihost Host part of the IRI
     * @property string $port Port part of the IRI (after ':')
     * @property string $path Path part, formatted for a URI (after first '/')
     * @property string $ipath Path part of the IRI (after first '/')
     * @property string $query Query part, formatted for a URI (after '?')
     * @property string $iquery Query part of the IRI (after '?')
     * @property string $fragment Fragment, formatted for a URI (after '#')
     * @property string $ifragment Fragment part of the IRI (after '#')
     */
    class Requests_IRI {
        /**
         * Scheme
         *
         * @var string|null
         */
        protected $scheme = \null;
        /**
         * User Information
         *
         * @var string|null
         */
        protected $iuserinfo = \null;
        /**
         * ihost
         *
         * @var string|null
         */
        protected $ihost = \null;
        /**
         * Port
         *
         * @var string|null
         */
        protected $port = \null;
        /**
         * ipath
         *
         * @var string
         */
        protected $ipath = '';
        /**
         * iquery
         *
         * @var string|null
         */
        protected $iquery = \null;
        /**
         * ifragment|null
         *
         * @var string
         */
        protected $ifragment = \null;
        /**
         * Normalization database
         *
         * Each key is the scheme, each value is an array with each key as the IRI
         * part and value as the default value for that part.
         *
         * @var array
         */
        protected $normalization = [
            'acap' => ['port' => 674],
            'dict' => ['port' => 2628],
            'file' => ['ihost' => 'localhost'],
            'http' => ['port' => 80],
            'https' => ['port' => 443],
        ];
        /**
         * Return the entire IRI when you try and read the object as a string
         *
         * @return string
         */
        public function __toString() {
        }
        /**
         * Overload __set() to provide access via properties
         *
         * @param string $name Property name
         * @param mixed $value Property value
         */
        public function __set($name, $value) {
        }
        /**
         * Overload __get() to provide access via properties
         *
         * @param string $name Property name
         * @return mixed
         */
        public function __get($name) {
        }
        /**
         * Overload __isset() to provide access via properties
         *
         * @param string $name Property name
         * @return bool
         */
        public function __isset($name) {
        }
        /**
         * Overload __unset() to provide access via properties
         *
         * @param string $name Property name
         */
        public function __unset($name) {
        }
        /**
         * Create a new IRI object, from a specified string
         *
         * @param string|null $iri
         */
        public function __construct($iri = \null) {
        }
        /**
         * Create a new IRI object by resolving a relative IRI
         *
         * Returns false if $base is not absolute, otherwise an IRI.
         *
         * @param Requests_IRI|string $base (Absolute) Base IRI
         * @param Requests_IRI|string $relative Relative IRI
         * @return Requests_IRI|false
         */
        public static function absolutize($base, $relative) {
        }
        /**
         * Parse an IRI into scheme/authority/path/query/fragment segments
         *
         * @param string $iri
         * @return array
         */
        protected function parse_iri($iri) {
        }
        /**
         * Remove dot segments from a path
         *
         * @param string $input
         * @return string
         */
        protected function remove_dot_segments($input) {
        }
        /**
         * Replace invalid character with percent encoding
         *
         * @param string $string Input string
         * @param string $extra_chars Valid characters not in iunreserved or
         *                            iprivate (this is ASCII-only)
         * @param bool $iprivate Allow iprivate
         * @return string
         */
        protected function replace_invalid_with_pct_encoding($string, $extra_chars, $iprivate = \false) {
        }
        /**
         * Callback function for preg_replace_callback.
         *
         * Removes sequences of percent encoded bytes that represent UTF-8
         * encoded characters in iunreserved
         *
         * @param array $match PCRE match
         * @return string Replacement
         */
        protected function remove_iunreserved_percent_encoded($match) {
        }
        protected function scheme_normalization() {
        }
        /**
         * Check if the object represents a valid IRI. This needs to be done on each
         * call as some things change depending on another part of the IRI.
         *
         * @return bool
         */
        public function is_valid() {
        }
        /**
         * Set the entire IRI. Returns true on success, false on failure (if there
         * are any invalid characters).
         *
         * @param string $iri
         * @return bool
         */
        protected function set_iri($iri) {
        }
        /**
         * Set the scheme. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $scheme
         * @return bool
         */
        protected function set_scheme($scheme) {
        }
        /**
         * Set the authority. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $authority
         * @return bool
         */
        protected function set_authority($authority) {
        }
        /**
         * Set the iuserinfo.
         *
         * @param string $iuserinfo
         * @return bool
         */
        protected function set_userinfo($iuserinfo) {
        }
        /**
         * Set the ihost. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $ihost
         * @return bool
         */
        protected function set_host($ihost) {
        }
        /**
         * Set the port. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $port
         * @return bool
         */
        protected function set_port($port) {
        }
        /**
         * Set the ipath.
         *
         * @param string $ipath
         * @return bool
         */
        protected function set_path($ipath) {
        }
        /**
         * Set the iquery.
         *
         * @param string $iquery
         * @return bool
         */
        protected function set_query($iquery) {
        }
        /**
         * Set the ifragment.
         *
         * @param string $ifragment
         * @return bool
         */
        protected function set_fragment($ifragment) {
        }
        /**
         * Convert an IRI to a URI (or parts thereof)
         *
         * @param string|bool IRI to convert (or false from {@see get_iri})
         * @return string|false URI if IRI is valid, false otherwise.
         */
        protected function to_uri($string) {
        }
        /**
         * Get the complete IRI
         *
         * @return string|false
         */
        protected function get_iri() {
        }
        /**
         * Get the complete URI
         *
         * @return string
         */
        protected function get_uri() {
        }
        /**
         * Get the complete iauthority
         *
         * @return string|null
         */
        protected function get_iauthority() {
        }
        /**
         * Get the complete authority
         *
         * @return string
         */
        protected function get_authority() {
        }
    }

    /**
     * IDNA URL encoder
     *
     * Note: Not fully compliant, as nameprep does nothing yet.
     *
     * @package Requests
     * @subpackage Utilities
     * @see https://tools.ietf.org/html/rfc3490 IDNA specification
     * @see https://tools.ietf.org/html/rfc3492 Punycode/Bootstrap specification
     */
    class Requests_IDNAEncoder {
        /**
         * ACE prefix used for IDNA
         *
         * @see https://tools.ietf.org/html/rfc3490#section-5
         * @var string
         */
        const ACE_PREFIX = 'xn--';
        /**#@+
         * Bootstrap constant for Punycode
         *
         * @see https://tools.ietf.org/html/rfc3492#section-5
         * @var int
         */
        const BOOTSTRAP_BASE = 36;
        const BOOTSTRAP_TMIN = 1;
        const BOOTSTRAP_TMAX = 26;
        const BOOTSTRAP_SKEW = 38;
        const BOOTSTRAP_DAMP = 700;
        const BOOTSTRAP_INITIAL_BIAS = 72;
        const BOOTSTRAP_INITIAL_N = 128;
        /**#@-*/
        /**
         * Encode a hostname using Punycode
         *
         * @param string $string Hostname
         * @return string Punycode-encoded hostname
         */
        public static function encode($string) {
        }
        /**
         * Convert a UTF-8 string to an ASCII string using Punycode
         *
         * @throws Requests_Exception Provided string longer than 64 ASCII characters (`idna.provided_too_long`)
         * @throws Requests_Exception Prepared string longer than 64 ASCII characters (`idna.prepared_too_long`)
         * @throws Requests_Exception Provided string already begins with xn-- (`idna.provided_is_prefixed`)
         * @throws Requests_Exception Encoded string longer than 64 ASCII characters (`idna.encoded_too_long`)
         *
         * @param string $string ASCII or UTF-8 string (max length 64 characters)
         * @return string ASCII string
         */
        public static function to_ascii($string) {
        }
        /**
         * Check whether a given string contains only ASCII characters
         *
         * @internal (Testing found regex was the fastest implementation)
         *
         * @param string $string
         * @return bool Is the string ASCII-only?
         */
        protected static function is_ascii($string) {
        }
        /**
         * Prepare a string for use as an IDNA name
         *
         * @todo Implement this based on RFC 3491 and the newer 5891
         * @param string $string
         * @return string Prepared string
         */
        protected static function nameprep($string) {
        }
        /**
         * Convert a UTF-8 string to a UCS-4 codepoint array
         *
         * Based on Requests_IRI::replace_invalid_with_pct_encoding()
         *
         * @throws Requests_Exception Invalid UTF-8 codepoint (`idna.invalidcodepoint`)
         * @param string $input
         * @return array Unicode code points
         */
        protected static function utf8_to_codepoints($input) {
        }
        /**
         * RFC3492-compliant encoder
         *
         * @internal Pseudo-code from Section 6.3 is commented with "#" next to relevant code
         * @throws Requests_Exception On character outside of the domain (never happens with Punycode) (`idna.character_outside_domain`)
         *
         * @param string $input UTF-8 encoded string to encode
         * @return string Punycode-encoded string
         */
        public static function punycode_encode($input) {
        }
        /**
         * Convert a digit to its respective character
         *
         * @see https://tools.ietf.org/html/rfc3492#section-5
         * @throws Requests_Exception On invalid digit (`idna.invalid_digit`)
         *
         * @param int $digit Digit in the range 0-35
         * @return string Single character corresponding to digit
         */
        protected static function digit_to_char($digit) {
        }
        /**
         * Adapt the bias
         *
         * @see https://tools.ietf.org/html/rfc3492#section-6.1
         * @param int $delta
         * @param int $numpoints
         * @param bool $firsttime
         * @return int New bias
         *
         * function adapt(delta,numpoints,firsttime):
         */
        protected static function adapt($delta, $numpoints, $firsttime) {
        }
    }
}
