import type { FC } from "react";

/**
 * Create a WordPress dash icon.
 *
 * @see https://developer.wordpress.org/resource/dashicons/
 */
const DashIcon: FC<{ name: string }> = ({ name }) => (
    <span className={`dashicons dashicons-${name}`} style={{ verticalAlign: "text-top" }} />
);

export { DashIcon };
