import { Spin } from "antd";
import { observer } from "mobx-react";

import { OptionsPostTypesTable } from "./postTypesTable.js";
import { useStores } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";
import { ConfigLicensing } from "../licensing/licensing.js";

import type { FC } from "react";

const OptionsPage: FC = observer(() => {
    const {
        optionStore: {
            busySettings,
            others: { showLicenseFormImmediate },
        },
    } = useStores();
    return showLicenseFormImmediate ? (
        <ConfigLicensing />
    ) : (
        <>
            <h1 className="wp-heading-inline" style={{ marginBottom: 10 }}>
                {__("Category Management")}
            </h1>
            <Spin spinning={busySettings}>
                <p className="description" style={{ marginBottom: 15 }}>
                    {__(
                        "You can decide for which post types the additional features of Real Category Management should apply.",
                    )}
                </p>
                <OptionsPostTypesTable />
            </Spin>
        </>
    );
});

export { OptionsPage };
