import { observer } from "mobx-react";

import { OptionsPostTypesRow } from "./postTypeRow.js";
import { useStores } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";
import { ProTag } from "../proTag.js";

import type { FC } from "react";

const OptionsPostTypesTable: FC = observer(() => {
    const {
        optionStore: {
            others: { postTypes },
        },
    } = useStores();

    return (
        <table className="wp-list-table widefat fixed striped table-view-list">
            <thead>
                <tr>
                    <td>{__("Post type")}</td>
                    <td width={250} align="right">
                        {__("Show category tree")}
                    </td>
                    <td width={350} align="right">
                        {__("Pagination without page reload")}&nbsp;
                        <ProTag feature="options-fast-mode" />
                    </td>
                </tr>
            </thead>
            <tbody>
                {Object.keys(postTypes).map((name) => (
                    <OptionsPostTypesRow key={name} name={name} />
                ))}
                <tr>
                    <td>
                        <strong>{__("Media")}</strong>
                    </td>
                    <td colSpan={2}>
                        <a
                            href={__("https://devowl.io/go/real-media-library?source=cross-rcm&feature=media-folders")}
                            target="_blank"
                            rel="noreferrer"
                        >
                            {__("Use Real Media Library to enable folder management")}
                        </a>
                    </td>
                </tr>
            </tbody>
        </table>
    );
});

export { OptionsPostTypesTable };
