import { observer } from "mobx-react";
import { Fragment } from "react";

import { Alert } from "@devowl-wp/react-folder-tree";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";
import { request } from "../utils/request.js";
import { locationRestNoticeLiteDelete } from "../wp-api/noticeLite.delete.js";

import type {
    ParamsRouteNoticeLiteDelete,
    RequestRouteNoticeLiteDelete,
    ResponseRouteNoticeLiteDelete,
} from "../wp-api/noticeLite.delete.js";
import type { FC } from "react";

async function dismiss() {
    await request<RequestRouteNoticeLiteDelete, ParamsRouteNoticeLiteDelete, ResponseRouteNoticeLiteDelete>({
        location: locationRestNoticeLiteDelete,
    });
    window.location.reload();
}

const ProFooter: FC<{ closeable: boolean }> = observer(({ closeable = false }) => {
    const {
        optionStore: {
            others: { proUrl },
        },
    } = useStores();

    return (
        <Alert
            message={
                <span>
                    {__("Thanks for using Real Category Management (Free).")}{" "}
                    <a href={`${proUrl}&feature=sidebar`} target="_blank" rel="noopener noreferrer">
                        {__("Learn more about PRO")}
                    </a>
                    {closeable && (
                        <>
                            {" "}
                            &middot;{" "}
                            <a onClick={dismiss} href="#">
                                {__("Hide for 30 days")}
                            </a>
                        </>
                    )}
                </span>
            }
            type="info"
            style={{ marginBottom: "10px" }}
        />
    );
});

const ProLink: FC<{ brackets: boolean }> = observer(({ brackets = false }) => {
    const {
        optionStore: {
            others: { proUrl },
        },
    } = useStores();

    return (
        <Fragment>
            {brackets && "("}
            <a href={proUrl} target="_blank" rel="noopener noreferrer">
                {__("PRO feature")}
            </a>
            {brackets && ")"}
        </Fragment>
    );
});

export { ProFooter, ProLink };
