import { UnlockOutlined } from "@ant-design/icons";
import { Tag } from "antd";
import { observer } from "mobx-react";
import { useCallback } from "react";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

const PRO_TAG_BACKGROUND_COLOR = "#2db7f5";

const ProTag = observer(({ feature }: { feature: string }) => {
    const {
        optionStore: {
            others: { isPro, proUrl },
        },
    } = useStores();

    const open = useCallback(() => {
        window.open(`${proUrl}&feature=${feature}`);
    }, []);

    return isPro ? null : (
        <Tag icon={<UnlockOutlined />} color={PRO_TAG_BACKGROUND_COLOR} style={{ cursor: "pointer" }} onClick={open}>
            {__("Unlock feature")}
        </Tag>
    );
});

export { ProTag, PRO_TAG_BACKGROUND_COLOR };
