import $ from "jquery";
import { useEffect } from "react";

import { loadFastModeContent } from "../../others/fastModeContent.js";
import { useStores } from "../../store/stores.js";

function usePaginationFastMode(fastModeContentLoaded?: () => void) {
    const {
        optionStore: {
            others: {
                screenSettings: { isFastMode },
            },
        },
    } = useStores();

    isFastMode &&
        useEffect(() => {
            const handler: JQuery.EventHandlerBase<any, any> = function (e) {
                loadFastModeContent($(this).attr("href")).then(fastModeContentLoaded);
                e.preventDefault();
                return false;
            };

            $(document).on("click", ".pagination-links a", handler);
            return () => {
                $(document).off("click", ".pagination-links a", handler);
            };
        });
}

export { usePaginationFastMode };
