/**
 * The entry point for the options page.
 */
import "@devowl-wp/utils/antd.scss";
import $ from "jquery";
import { createRoot } from "react-dom/client";

import { handleCorruptRestApi } from "@devowl-wp/utils";

import { OptionsPage } from "./components/optionsPage/optionsPage.js";
import { Provider } from "./components/provider.js";
import { RootStore } from "./store/stores.js";
import { request } from "./utils/request.js";

handleCorruptRestApi({
    [RootStore.get.optionStore.restNamespace]: async () => {
        await request({
            location: {
                path: "/plugin",
            },
        });
    },
});

const node = document.getElementById(`${RootStore.get.optionStore.slug}-component`);

$(() => {
    if (node) {
        createRoot(node).render(
            <Provider>
                <OptionsPage />
            </Provider>,
        );
    }
});

$("link#dark_mode-css").length && $("body").addClass("aiot-wp-dark-mode");

// Expose this functionalities to add-ons, but you need to activate the library functionality
// in your webpack configuration, see also https://webpack.js.org/guides/author-libraries/
export * from "@devowl-wp/utils";
export * from "./wp-api/index.js";
export * from "./store/index.js";
