import $ from "jquery";
import { createRoot } from "react-dom/client";

import { ListTableTreeSwitch } from "../components/listTableTreeSwitch.js";
import { Provider } from "../components/provider.js";

/**
 * Add a switch to the list table if tax tree can be enabled for the current page.
 */
function addSwitchToListTable() {
    const container = $("<div/>")
        .appendTo("#posts-filter > .tablenav.top > .alignleft.actions:not(.bulkactions)")
        .css({ float: "right" })
        .get(0);

    if (container) {
        createRoot(container).render(
            <Provider>
                <ListTableTreeSwitch />
            </Provider>,
        );
    }
}

export { addSwitchToListTable };
