import { applyQueryString } from "@devowl-wp/utils";

/**
 * Add a URL parameter (or changing it if it already exists)
 *
 * @param url
 * @param parameterName
 * @param parameterValue
 */
function addUrlParam(url: string, parameterName: string, parameterValue: any) {
    return applyQueryString(new URL(url, window.location.href), [{ [parameterName]: parameterValue }], true).toString();
}

export { addUrlParam };
