import { BaseOptions, createRequestFactory } from "@devowl-wp/utils";

// Only needed once per `window`
let FACTORY_MEMO: ReturnType<typeof createRequestFactory>;

function get() {
    return FACTORY_MEMO
        ? FACTORY_MEMO
        : (FACTORY_MEMO = createRequestFactory((window as any)[BaseOptions.getPureSlug(process.env.slug, true)]));
}

const urlBuilder: (typeof FACTORY_MEMO)["urlBuilder"] = (...args) => get().urlBuilder(...args);
const request: (typeof FACTORY_MEMO)["request"] = (...args) => get().request(...args);

export { urlBuilder, request };
