import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestHierarchyPut: RouteLocationInterface = {
    path: "/hierarchy/:id",
    method: RouteHttpVerb.PUT,
};

interface RequestRouteHierarchyPut extends RouteRequestInterface {
    parent: number;
    nextId: number;
    type: string;
    taxonomy: string;
}

interface ParamsRouteHierarchyPut extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteHierarchyPut extends RouteResponseInterface {}

export {
    locationRestHierarchyPut,
    type RequestRouteHierarchyPut,
    type ParamsRouteHierarchyPut,
    type ResponseRouteHierarchyPut,
};
