import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestOptionsPostTypePatch: RouteLocationInterface = {
    path: "/options/:post_type",
    method: RouteHttpVerb.PATCH,
};

interface RequestRouteOptionsPostTypePatch extends RouteRequestInterface {
    active?: boolean;
    fastMode?: boolean;
}

interface ParamsRouteOptionsPostTypePatch extends RouteParamsInterface {
    post_type: string;
}

interface ResponseRouteOptionsPostTypePatch extends RouteResponseInterface {
    active?: boolean;
    fastMode?: boolean;
}

export {
    locationRestOptionsPostTypePatch,
    type RequestRouteOptionsPostTypePatch,
    type ParamsRouteOptionsPostTypePatch,
    type ResponseRouteOptionsPostTypePatch,
};
