import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestPostsBulkMovePut: RouteLocationInterface = {
    path: "/posts/bulk/move",
    method: RouteHttpVerb.PUT,
};

interface RequestRoutePostsBulkMovePut extends RouteRequestInterface {
    ids: number[];
    to: number;
    isCopy: boolean;
    taxonomy: string;
}

interface ParamsRoutePostsBulkMovePut extends RouteParamsInterface {}

interface ResponseRoutePostsBulkMovePut extends RouteResponseInterface {}

export {
    locationRestPostsBulkMovePut,
    type RequestRoutePostsBulkMovePut,
    type ParamsRoutePostsBulkMovePut,
    type ResponseRoutePostsBulkMovePut,
};
