import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTermsDelete: RouteLocationInterface = {
    path: "/terms/:id",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteTermsDelete extends RouteRequestInterface {}

interface ParamsRouteTermsDelete extends RouteParamsInterface {
    id: number;
    taxonomy: string;
}

interface ResponseRouteTermsDelete extends RouteResponseInterface {}

export {
    locationRestTermsDelete,
    type RequestRouteTermsDelete,
    type ParamsRouteTermsDelete,
    type ResponseRouteTermsDelete,
};
