import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTermsPost: RouteLocationInterface = {
    path: "/terms",
    method: RouteHttpVerb.POST,
};

interface RequestRouteTermsPost extends RouteRequestInterface {
    name: string;
    parent: number;
    type: string;
    taxonomy: string;
}

interface ParamsRouteTermsPost extends RouteParamsInterface {}

interface ResponseRouteTermsPost extends RouteResponseInterface {
    count: number;
    description: string;
    editableSlug: string;
    filter: string;
    name: string;
    parent: number;
    queryArgs: {
        [key: string]: string;
    };
    category_name: string;
    post_type: string;
    slug: string;
    taxonomy: string;
    term_group: number;
    term_id: number;
    term_order: string;
    term_taxonomy_id: number;
}

export { locationRestTermsPost, type RequestRouteTermsPost, type ParamsRouteTermsPost, type ResponseRouteTermsPost };
