import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTermsPut: RouteLocationInterface = {
    path: "/terms/:id",
    method: RouteHttpVerb.PUT,
};

interface RequestRouteTermsPut extends RouteRequestInterface {
    name: string;
    taxonomy: string;
}

interface ParamsRouteTermsPut extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteTermsPut extends RouteResponseInterface {
    term_id: number;
    term_taxonomy_id: number;
}

export { locationRestTermsPut, type RequestRouteTermsPut, type ParamsRouteTermsPut, type ResponseRouteTermsPut };
