import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTreeGet: RouteLocationInterface = {
    path: "/tree",
    method: RouteHttpVerb.GET,
};

interface RequestRouteTreeGet extends RouteRequestInterface {}

interface ParamsRouteTreeGet extends RouteParamsInterface {
    remember: boolean;
    type: string;
    taxonomy: string;
}

interface SingleTreeItem {
    childNodes: SingleTreeItem[];
    count: number;
    editableSlug: string;
    name: string;
    queryArgs: {
        [key: string]: string;
    };
    category_name: string;
    post_type: string;
    taxonomy: string;
    term_id: number;
}

interface ResponseRouteTreeGet extends RouteResponseInterface {
    selectedId: number | "ALL";
    tree: SingleTreeItem[];
}

export {
    locationRestTreeGet,
    type RequestRouteTreeGet,
    type ParamsRouteTreeGet,
    type SingleTreeItem,
    type ResponseRouteTreeGet,
};
