<?php
namespace DevOwl\RealCookieBanner\lite\view\blocker;

use DevOwl\FastHtmlTag\finder\match\AbstractMatch;
use DevOwl\HeadlessContentBlocker\BlockedResult;

// @codeCoverageIgnoreStart
defined('ABSPATH') or die('No script kiddies please!'); // Avoid direct file request
// @codeCoverageIgnoreEnd

/**
 * Implementation for `ImagePreviewBlockable`.
 */
trait ImagePreviewBlockableTrait {
    /**
     * See `ImagePreviewBlockable`.
     *
     * @param string $url
     * @param BlockedResult $result
     * @param AbstractMatch $match
     * @return boolean
     */
    public function downloadImagePreviewFor($url, $result, $match) {
        $metas = $this->getPost()->metas;
        return $metas['visualDownloadThumbnail'] ?? false;
    }
}
