/**
 * The entry point for the admin side wp-admin resource (config page).
 */
import "@devowl-wp/utils/antd.scss";
import "./style/admin.scss";
import moment from "moment";
import { createRoot } from "react-dom/client";

import { handleCorruptRestApi } from "@devowl-wp/utils";

import { ConfigApp } from "./components/configApp.js";
import { Provider } from "./components/provider.js";
import { RootStore } from "./store/stores.js";
import { __ } from "./utils/i18n.js";
import { request } from "./utils/request.js";

handleCorruptRestApi({
    [RootStore.get.optionStore.restNamespace]: async () => {
        await request({
            location: {
                path: "/plugin",
            },
        });
    },
    ["wp/v2"]: async () => {
        await request({
            location: {
                path: "/posts",
                namespace: "wp/v2",
            },
        });
    },
});

const node = document.getElementById(`${RootStore.get.optionStore.slug}-component`);

if (node) {
    createRoot(node).render(
        <Provider
            configProvider={{
                locale: { locale: moment.locale(), Pagination: { items_per_page: __("/ page") } },
            }}
        >
            <ConfigApp />
        </Provider>,
    );
}

// Expose this functionalities to add-ons, but you need to activate the library functionality
// in your webpack configuration, see also https://webpack.js.org/guides/author-libraries/
export * from "@devowl-wp/utils";
export * from "./wp-api/index.js";
export * from "./store/index.js";
